﻿<?xml version = "1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<!-- ELP_ELM_REPORT_TITLE_STRING: ^0300^ -->
<!-- Copyright @2004 Motorola Inc.  All rights reserved -->
<!-- Subset of the Detailed Report.  -->
<picture_list />
   <xsl:template match = "/">
      <xsl:text disable-output-escaping = "yes"> 
	&lt;html dir=^0034^>
&lt;meta http-equiv="Content-Type" CONTENT = "text/html; charset=utf-8"> 
      </xsl:text>
         <head>
            <title>
            ^0014^ 
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_SERIALNUM" />
            ^0013^
            <xsl:value-of select = "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM" />
            </title>
            <xsl:text disable-output-escaping = "yes">
               &lt;style>
                  &lt;!--
                  h1 {text-align: center; font-size:26; color: blue}
                  h1.breakBefore {text-align: center; font-size:26; color: blue;page-break-before: always}
                  h4 {text-align: left; font-size: 10}
                  table.solo {page-break-after: always}
                  td {vertical-align: top; font-size: 10}
                  th {text-align: left; font-size: 12; font-weight: bold; color: blue}
                  td.em1 {text-align: left; font-size: 12; font-weight: bold; color: blue}
                  td.em {vertical-align: top; font-size: 10; font-weight: bold}
                  -->
               &lt;/style>
            </xsl:text>
         </head>
         <body>
            <table>		            
		<xsl:if test ="contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')">
		    <xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE" />
		</xsl:if>
		
		<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM" />
		<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_SERIALNUM" />
		
		<xsl:if test ="contains(ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'Japan')">
			<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_FIRMVER" />
			<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATTIME" />
			<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_TANAPANUM" />
			<xsl:apply-templates select= "ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_ATISNO" />
		</xsl:if>            
            </table>
            <h1> ^0331^ </h1>
            <xsl:variable name = "start">1</xsl:variable>
            <xsl:variable name = "end">
               <xsl:value-of select = "count(ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA)" />
            </xsl:variable>
            <xsl:variable name = "cycle">
               <xsl:value-of select = "ceiling(  count(ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA) div 8  )" />
            </xsl:variable>
            <xsl:if test = "$cycle &gt;= 1">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">1</xsl:with-param>
                      <xsl:with-param name = "endIndex">8</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 2">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">9</xsl:with-param>
                      <xsl:with-param name = "endIndex">16</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 3">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">17</xsl:with-param>
                      <xsl:with-param name = "endIndex">24</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 4">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">25</xsl:with-param>
                      <xsl:with-param name = "endIndex">32</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 5">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">33</xsl:with-param>
                      <xsl:with-param name = "endIndex">40</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 6">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">41</xsl:with-param>
                      <xsl:with-param name = "endIndex">48</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 7">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">49</xsl:with-param>
                      <xsl:with-param name = "endIndex">56</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 8">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">57</xsl:with-param>
                      <xsl:with-param name = "endIndex">64</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 9">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">65</xsl:with-param>
                      <xsl:with-param name = "endIndex">72</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 10">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">73</xsl:with-param>
                      <xsl:with-param name = "endIndex">80</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 11">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">81</xsl:with-param>
                      <xsl:with-param name = "endIndex">88</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 12">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">89</xsl:with-param>
                      <xsl:with-param name = "endIndex">96</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            <xsl:if test = "$cycle &gt;= 13">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">97</xsl:with-param>
                      <xsl:with-param name = "endIndex">104</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 14">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">105</xsl:with-param>
                      <xsl:with-param name = "endIndex">112</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 15">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">113</xsl:with-param>
                      <xsl:with-param name = "endIndex">120</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <xsl:if test = "$cycle &gt;= 16">
               <h3 class = "breakBefore"> ^0402^ </h3>
                  <xsl:call-template name = "PERS_TABLE">
                      <xsl:with-param name = "startIndex">121</xsl:with-param>
                      <xsl:with-param name = "endIndex">128</xsl:with-param>
                       <xsl:with-param name = "break">no</xsl:with-param>
                  </xsl:call-template>
            </xsl:if>
            
            <!-- for ltr -->
            <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR = 1">
                <h1 class = "breakBefore">^0801^</h1>
                <xsl:call-template name = 'lg_loop' >
                    <xsl:with-param name = "times" select = '1' />
                </xsl:call-template>
            </xsl:if>
            
            <!-- Position -->
            <h1 class = "breakBefore">^0807^</h1>
            <table>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/PA_BLOCK/X_PA_LIST/X_CHANNAL_ALIAS" />
            </table>
                       
         </body>
         <xsl:text disable-output-escaping = "yes"> &lt;/meta> &lt;/html> </xsl:text>
      </xsl:template>      
      
      <xsl:template name = "PERS_TABLE">
         <xsl:param name = "startIndex">1</xsl:param>
         <xsl:param name = "endIndex">8</xsl:param>
         <xsl:param name = "break">no</xsl:param>
         <xsl:if test = "$break = 'no'">
            <xsl:text disable-output-escaping = "yes">
               &lt;table>
            </xsl:text>
         </xsl:if>
         <xsl:if test = "$break = 'yes'">
            <xsl:text disable-output-escaping = "yes">
               &lt;table class = "solo">
            </xsl:text>
         </xsl:if>
         <tr>
            <xsl:text disable-output-escaping = "yes">
               &lt;th width = "25%"> &amp;nbsp &lt;/th>
            </xsl:text>       
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_ALIAS" />
         </tr>
         <tr> 
            <td class = "em">
               ^0803^
            </td>
            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_CHNNELPOSITION">
                <xsl:with-param name = 'start' select = '$startIndex'/>
            </xsl:apply-templates>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_CHBWSEL/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_CHBWSEL"/>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_SCANLISTINDEX/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_SCANLISTINDEX" />
         </tr>
         <tr>
            <td class = "em">
              <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_AUTOSCANEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_AUTOSCANEN" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/X_CP_COMPANDING/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_COMPANDING" />
         </tr>
        <xsl:if test = "not(contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/RC_KANIIPPANMODE, 'Kani'))">
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TALKAROUNDEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TALKAROUNDEN" />
         </tr> 
        </xsl:if>        
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_RXONLY/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXONLY"/>
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_EMPSEL/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_EMPSEL" />
         </tr>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_SQSET/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_SQSET" />
         </tr>

         <xsl:choose>
            <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PFK') or
			      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PLK') or
			      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'MPLUS') ">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_PHSYSINDEX/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_PHSYSINDEX" />
               </tr>
            </xsl:when>
         </xsl:choose>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'MPLUS')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_OPTBRDFEATEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_OPTBRDFEATEN" />
           </tr>
         </xsl:if>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_FLATTXAUDIOEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_FLATTXAUDIOEN" />
           </tr>
         </xsl:if>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PNK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PLK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'PFK') or 
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,'MPLUS')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_OPTBRDCONFIGINDEX/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_OPTBRDCONFIGINDEX" />
           </tr>
         </xsl:if>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                         contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN')">
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_DATAREVERTPERINDEX/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_DATAREVERTPERINDEX" />
           </tr>
         </xsl:if>
           <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_SDT, '1')">
               <tr>
	            <td class = "em">
	               <xsl:value-of select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_DATATRANSOB/@DISPLAY_NAME" />:
	            </td>
              	    <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_DATATRANSOB" />
               </tr>
          </xsl:if>
          
          <!-- Added by Alice Wan, CCB410 -->
          <xsl:variable name = "cpver">
	        <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
          </xsl:variable>
          <xsl:variable name = "MDFArtsFlag">
	        <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_ARTS"/>
          </xsl:variable>	   	 
          <xsl:variable name ="ArtsEnable">
	        <xsl:value-of select="($cpver >= '09.00') and ($MDFArtsFlag = '1')"/>
          </xsl:variable>    
          <xsl:if test = "($ArtsEnable = 'true')"> 
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_ARTSEN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_ARTSEN" />
           </tr>
         </xsl:if>
         
         <xsl:variable name = "MDFLoneWorkerFlag">
	        <xsl:value-of select ="/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LONEWOKER"/>
          </xsl:variable>	   	 
          <xsl:variable name ="LoneWorkerEnable">
	        <xsl:value-of select="($cpver >= '09.00') and ($MDFLoneWorkerFlag = '1')"/>
          </xsl:variable>
          <xsl:if test = "($LoneWorkerEnable = 'true')"> 
           <tr>
              <td class = "em">
                 <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_LONEWOKEREN/@DISPLAY_NAME" />
              </td>                  
              <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_LONEWOKEREN" />
           </tr>
         </xsl:if>
         <!-- Added by Alice Wan, CCB410 -->

         <!-- Rx Parameters -->
         <tr>
            <td class = "em1">
               ^0302^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "counting_space" />
         </tr>
         <tr>
            <td class = "em">
               ^0317^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXFREQ"/>
         </tr>
         <tr>
            <td class = "em">
               ^0319^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXSQCODESEL"/>
         </tr>            
         <tr>
            <td class = "em">
               ^0305^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDECDATA_DPL"/>
         </tr>
         <tr>
            <td class = "em">
               ^0321^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDPLINVERT"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0303^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXDECDATA_TPL" />
         </tr>
         <tr>
            <td class = "em">
               ^0304^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_RX_TPL_CODE" />
         </tr>
	        <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50KCC9AA2AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA2AN')) ">
	         <tr>
	            <td class = "em">
	               ^0325^
	            </td>                  
	            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_RXSIGTYPE" />
	         </tr>
         
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_PLREQFORDATA/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_PLREQFORDATA" />
         </tr>            
         
	         <tr>
	            <td class = "em">
	               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_SIGSQ/@DISPLAY_NAME" />
	            </td>                  
	            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_SIGSQ" />
	         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_UNMUTETYPE/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_UNMUTETYPE" />
         </tr>
         <tr>
           <td class = "em">
               ^0329^
           </td>                  
           <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RXREFFREQ" />
         </tr>
         <tr>
            <td class = "em1">
               ^0306^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "counting_space" />
         </tr>
         <tr>
            <td class = "em">
               ^0318^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXFREQ"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0320^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXSQCODESEL"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0309^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXENCDATA_DPL"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0322^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXDPLINVERT"/>
         </tr>         
         <tr>
            <td class = "em">
               ^0307^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXENCDATA_TPL"/>
         </tr>
         <tr>
            <td class = "em">
               ^0308^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_TX_TPL_CODE"/> 
         </tr>         
         <xsl:if test="not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM,  'H50KCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50KCC9AA2AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA1AN')) and
		     		not(contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_MODELNUM, 'H50RCC9AA2AN')) ">
	         <tr>
	            <td class = "em">
	               ^0326^
	            </td>                  
	            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_TXSIGTYPE" />
	         </tr>         
	         <tr>
	            <td class = "em">
	               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TXPWRLEVSEL/@DISPLAY_NAME" />
	            </td>          
	            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" 	mode = "CP_TXPWRLEVSEL" />
	         </tr>
	 </xsl:if>
         <tr>
            <td class = "em">
               <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_VOXEN/@DISPLAY_NAME" />
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_VOXEN" />
         </tr>

         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PFK') or
			                   contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PLK') or
                            contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL,  'PNK')">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/X_CP_WHISPER/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_WHISPER" />
               </tr>
            </xsl:if>
         </xsl:if>
         
         <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
			 <tr>
				<td class = "em">
				   <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TOTTYPE/@DISPLAY_NAME" />
				</td>                  
				<xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOTTYPE" />
			 </tr>
		 </xsl:if>
         <xsl:choose>
            <xsl:when test = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TOTTYPE = '^0627^'">
               <tr>
                  <td class = "em">
                     <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TOT/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOT" />
               </tr>            
            </xsl:when>
            <xsl:otherwise>
               <tr>
                  <td class = "em">
                     <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_TOT/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TOT" />
               </tr>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:choose>
            <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PNK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MARLIN') or 
                              contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') or
                              (contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA') and contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'GUPPY')) ">
              <tr>
                  <td class = "em">
                     <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_RESETDURINHDUR/@DISPLAY_NAME" />
                  </td>                  
                  <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_RESETDURINHDUR" />
               </tr>
            </xsl:when>
         </xsl:choose>

         <tr>
            <td class = "em">
               ^0330^
            </td>                  
            <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXREFFREQ" />
         </tr>
         <tr>
            <td class = "em">
               ^0324^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "TX_DPL_TURNOFF_CODE"/>
         </tr>
         <tr>
            <td class = "em">
               ^0323^
            </td>
            <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_CP_REVBURST"/>
         </tr>                  
         <xsl:choose>
		      <xsl:when test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
				   <!-- Extended EMEA List -->
					 <tr>
						<td class = "em">
						   ^0332^
						</td>                  
						<xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_TXADMITCRITERIA" />
					 </tr>
			   </xsl:when>
			<xsl:otherwise>
				<tr>
					<td class = "em">
					   <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_BUSYCHLKOUT/@DISPLAY_NAME" />
					</td>                  
					<xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_BUSYCHLKOUT" />
				 </tr>
			</xsl:otherwise>
		</xsl:choose>

      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRO/RI_BLOCK/ENTRY_DATA/RI_REGID, 'EMEA')">
        <tr>
           <td class = "em">
              <xsl:value-of select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA/CP_CARRIERTIMERDUR/@DISPLAY_NAME" />
           </td>                  
           <xsl:apply-templates select="ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "CP_CARRIERTIMERDUR" />
         </tr>
      </xsl:if>
      
      <xsl:text disable-output-escaping = "yes">
               &lt;/table>
      </xsl:text>
      </xsl:template>
      
 

   <xsl:template match="RI_SERIALNUM">
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>

   <xsl:template match="RI_MODELNUM">
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." />
         </td>
      </tr>
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "counting_space">
      <td />
   </xsl:template>

   <xsl:template match = "ENTRY_DATA" mode = "CP_PHSYSINDEX">
      <td>
         <xsl:if test = "contains(CP_PHSYSINDEX, '^0602^')">
            <xsl:value-of select = "CP_PHSYSINDEX" />
         </xsl:if>
		 
		 <xsl:if test = "not(contains(CP_PHSYSINDEX, '^0602^'))">
         	<xsl:variable name = "index2">
			   <xsl:value-of select = "CP_PHSYSINDEX" />
			</xsl:variable> 
            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/PS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" />
         </xsl:if>
      </td>         
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_CP_CHNNELPOSITION">
       <xsl:param name = 'start'/>
       <td>
               <xsl:variable name = 'index' select = 'position()-1+$start -1' />
               <xsl:variable name = 'type'>Conventional</xsl:variable>
               <xsl:apply-templates select = '/ELP_ELM_CODEPLUG/RRW/PA_BLOCK/LIST_DATA/ENTRY_DATA[PA_PERSTYPE = $type and PA_PERSINDEX = $index]' mode = 'channel_position'/>
       </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_OPTBRDFEATEN">
      <td>
         <xsl:value-of select = "CP_OPTBRDFEATEN" />
      </td>
   </xsl:template>


   <xsl:template match="ENTRY_DATA" mode = "CP_FLATTXAUDIOEN">
      <td>
         <xsl:value-of select = "CP_FLATTXAUDIOEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_OPTBRDCONFIGINDEX">
	  <td>
         <xsl:value-of select = "CP_OPTBRDCONFIGINDEX" />
      </td>
   </xsl:template>
   
   
   <xsl:template match="ENTRY_DATA" mode = "CP_CHBWSEL">
      <td>
         <xsl:apply-templates select = "CP_CHBWSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXONLY">
	  <td>
         <xsl:value-of select = "X_CP_RXONLY" />
      </td>
   </xsl:template>
   
   <!-- Added by Alice Wan, CCB410 -->  
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->
   <xsl:template match="ENTRY_DATA" mode = "CP_ARTSEN">
      <td>      
         <xsl:choose>
            <xsl:when test = "CP_RXSQCODESEL = '^0614^' 
                           or CP_TXSQCODESEL = '^0614^'">
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select = "CP_ARTSEN" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 2010-6-7 -->
   
   <xsl:template match="ENTRY_DATA" mode = "CP_LONEWOKEREN">
      <td>
         <xsl:value-of select = "CP_LONEWOKEREN" />
      </td>
   </xsl:template>
   <!-- Added by Alice Wan, CCB410 -->

   <xsl:template match="ENTRY_DATA" mode = "CP_RXFREQ">
	  <td>
         <xsl:apply-templates select = "CP_RXFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSQCODESEL">
	  <td>
         <xsl:apply-templates select = "CP_RXSQCODESEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXSQCODESEL">
	  <td>
         <xsl:value-of select = "CP_TXSQCODESEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDECDATA_DPL">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_RXDECDATA" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDECDATA_TPL">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0613^'">
            <xsl:value-of select = "CP_RXDECDATA" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXDPLINVERT">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSQCODESEL = '^0612^'">
               <xsl:value-of select = "CP_RXDPLINVERT" />
            </xsl:when>
            <xsl:otherwise>
               ^0316^
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXFREQ">
	  <td>
         <xsl:apply-templates select = "CP_TXFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSQCODESEL">
	  <td>
         <xsl:apply-templates select = "CP_RXSQCODESEL" />
      </td>
   </xsl:template>


   <xsl:template match="ENTRY_DATA" mode = "CP_TXENCDATA_DPL">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TXENCDATA" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXENCDATA_TPL">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "CP_TXENCDATA" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_REVBURST">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_REVBURST" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXDPLINVERT">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TXDPLINVERT" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TALKAROUNDEN">
	  <td>
         <xsl:value-of select = "CP_TALKAROUNDEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_VOXEN">
	  <td>
         <xsl:value-of select = "CP_VOXEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXPWRLEVSEL">
	  <td>
         <xsl:apply-templates select = "CP_TXPWRLEVSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TOT">
	  <td>
         <xsl:apply-templates select = "CP_TOT" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TOTTYPE">
	  <td>
         <xsl:value-of select = "CP_TOTTYPE" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RESETDURINHDUR">
	  <td>
         <xsl:value-of select = "CP_RESETDURINHDUR" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SQSET">
	  <td>
         <xsl:apply-templates select = "CP_SQSET" />
      </td>
   </xsl:template>
   
   <xsl:template match="ENTRY_DATA" mode = "X_CP_WHISPER">
	  <td>
         <xsl:value-of select = "X_CP_WHISPER" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_CARRIERTIMERDUR">
	  <td>
         <xsl:apply-templates select = "CP_CARRIERTIMERDUR" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_UNMUTETYPE">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL != '^0614^'">
            <xsl:value-of select = "CP_UNMUTETYPE" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL = '^0614^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_BUSYCHLKOUT">
	  <td>
         <xsl:apply-templates select = "CP_BUSYCHLKOUT" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXSIGTYPE">
	  <td>
         <xsl:value-of select = "CP_RXSIGTYPE" />
	   <xsl:text disable-output-escaping = "yes">
		&amp;nbsp;
	   </xsl:text>
	   <xsl:variable name = "index2">
	 	<xsl:value-of select = "CP_RXSIGINDEX" />
	   </xsl:variable>
	   <xsl:if test = "CP_RXSIGTYPE = '^0625^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = '^0616^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = '^0624^'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'ATIS'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'SDT'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SDT_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_RXSIGTYPE = 'None'">
	     ^0327^
	   </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_PLREQFORDATA">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSIGTYPE = 'None'">
               ^0316^
            </xsl:when>
            <xsl:when test = "CP_RXSIGTYPE != 'None' and 
                               CP_RXSQCODESEL = '^0614^'" >
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:value-of select = "CP_PLREQFORDATA" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SIGSQ">
	  <td>
         <xsl:choose>
            <xsl:when test = "CP_RXSIGTYPE = 'None'">
               ^0316^
            </xsl:when>
            <xsl:otherwise>
               <xsl:apply-templates select = "CP_SIGSQ" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXSIGTYPE">
	  <td>
         <xsl:value-of select = "CP_TXSIGTYPE" />
	   <xsl:text disable-output-escaping = "yes">
		   &amp;nbsp;
	   </xsl:text>
	   <xsl:variable name = "index2">
	 	   <xsl:value-of select = "CP_TXSIGINDEX" />
	   </xsl:variable>
	   <xsl:if test = "CP_TXSIGTYPE = '^0625^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/QC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = '^0616^'">
	     <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = '^0624^'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/DTMF_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'ATIS'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/ATIS_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'SDT'">
	       <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SDT_BLOCK/ENTRY_DATA[position() = ($index2 + 1)]/ALIAS" /> 
	   </xsl:if>
	   <xsl:if test = "CP_TXSIGTYPE = 'None'">
	     ^0327^
	   </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_SCANLISTINDEX">
	  <td>
         <xsl:apply-templates select = "CP_SCANLISTINDEX" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_AUTOSCANEN">
	  <td>
         <xsl:value-of select = "CP_AUTOSCANEN" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_COMPANDING">
	  <td>
         <xsl:apply-templates select = "X_CP_COMPANDING" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_EXPTYPE">
	  <td>
         <xsl:apply-templates select = "CP_EXPTYPE" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_EMPSEL">
	  <td>
         <xsl:apply-templates select = "CP_EMPSEL" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_RXREFFREQ">
	  <td>
         <xsl:apply-templates select = "CP_RXREFFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_TXREFFREQ">
      <td>
         <xsl:apply-templates select = "CP_TXREFFREQ" />
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_RX_TPL_CODE">
	  <td>
         <xsl:if test = "CP_RXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_RX_TPL_CODE" />
         </xsl:if>
         <xsl:if test = "CP_RXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "CP_DATAREVERTPERINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "CP_DATAREVERTPERINDEX" />
      </xsl:variable>
      <xsl:variable name = "con_type">Conventional</xsl:variable>
      <xsl:variable name = "lty_type">LS Trunking</xsl:variable>
      <xsl:choose>
          <xsl:when test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_LTR != 1">
              <td><xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>  
          <xsl:when test = "$con_type = CP_DATAREVERTPERTYPE">
              <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
          <xsl:when test = "$lty_type = CP_DATAREVERTPERTYPE">
              <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
      </xsl:choose>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "X_CP_TX_TPL_CODE">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0613^'">
            <xsl:value-of select = "X_CP_TX_TPL_CODE" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0613^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ENTRY_DATA" mode = "TX_DPL_TURNOFF_CODE">
	  <td>
         <xsl:if test = "CP_TXSQCODESEL = '^0612^'">
            <xsl:value-of select = "CP_TOCEN" />
         </xsl:if>
         <xsl:if test = "CP_TXSQCODESEL != '^0612^'">
            ^0316^
         </xsl:if>
      </td>
   </xsl:template>

   <xsl:template match="ALIAS">
      <xsl:variable name = "oldAlias">
         <xsl:value-of select="." />
      </xsl:variable>
      <xsl:call-template name = "aliastransform">
         <xsl:with-param name = "aliasname1">
            <xsl:value-of select = "$oldAlias" />
         </xsl:with-param>
      </xsl:call-template>
   </xsl:template>

   <xsl:template match="CP_CHBWSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXSQCODESEL">
      <xsl:value-of select="." /> 
   </xsl:template>      
      
   <xsl:template match="CP_TXFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXENCDATA">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_REVBURSTTOCEN">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXPWRLEVSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TOT">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_SQSET">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_UNMUTETYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_BUSYCHLKOUT">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXSIGTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_TXSIGTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_SCANLISTINDEX">
      <xsl:variable name = "index">
         <xsl:value-of select = "./text()" />
      </xsl:variable>
      
      <xsl:choose>
         <xsl:when test = "$index = '255'">
            ^0327^
         </xsl:when>
         <xsl:when test = "$index != '255'"> 
            <xsl:apply-templates select = "../../../SLI_BLOCK/LIST_DATA[position() = ($index +1)]/ENTRY_INFO/ALIAS" />
         </xsl:when>
      </xsl:choose>
   </xsl:template>
   
   <xsl:template match = "ENTRY_INFO" mode = "sli">
      <xsl:apply-templates select = "ALIAS" />
   </xsl:template>
      
   <xsl:template match="CP_AUTOSCANEN">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="X_CP_COMPANDING">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_EXPTYPE">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_EMPSEL">
      <xsl:value-of select="." /> 
   </xsl:template>
      
   <xsl:template match="CP_RXREFFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
   
   <xsl:template match="CP_TXREFFREQ">
      <xsl:value-of select="." /> 
   </xsl:template>
      	  
   <xsl:template match="ENTRY_DATA" mode = "CP_TXADMITCRITERIA">
	  <td>
	     <xsl:value-of select="CP_TXADMITCRITERIA" /> 
	  </td>
   </xsl:template>

   <xsl:template name="aliastransform">
      <xsl:param name="aliasname1"></xsl:param>
         <xsl:variable name = "x1">
            <xsl:value-of select="translate($aliasname1, '(', '&amp;')"/>      
         </xsl:variable>
         <xsl:value-of select = "translate($x1, ')?!$%', 'nbsp;')" />
   </xsl:template>
   
   <xsl:template name = 'lg_loop'>
       <xsl:variable name = "lg_cycle">
          <xsl:value-of select = "ceiling(  number(ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_INFO/ENTRY_QUANTITY) div 8  )" />
       </xsl:variable>
       <xsl:param name = 'times' />
       <xsl:if test = "$lg_cycle &gt;= $times" >
           <h3 class = "breakBefore"> ^0802^ </h3>
           <xsl:call-template name = "LG_TABLE">
               <xsl:with-param name = "startIndex" select = '$times * 8 - 7' />
               <xsl:with-param name = "endIndex" select = '8 * $times'/>
               <xsl:with-param name = "break">no</xsl:with-param>
           </xsl:call-template>
           <xsl:call-template name = 'lg_loop'> 
               <xsl:with-param name = 'times' select = '$times + 1' />
           </xsl:call-template>
       </xsl:if>  
   </xsl:template>
      
   <xsl:template name = "LG_TABLE">
      <xsl:param name = "startIndex">1</xsl:param>
      <xsl:param name = "endIndex">8</xsl:param>
      <xsl:param name = "break">no</xsl:param>
      <xsl:if test = "$break = 'no'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table>
         </xsl:text>
      </xsl:if>
      <xsl:if test = "$break = 'yes'">
         <xsl:text disable-output-escaping = "yes">
            &lt;table class = "solo">
         </xsl:text>         
      </xsl:if>
      
      <tr>
         <xsl:text disable-output-escaping = "yes">
            &lt;th width = "25%"> &amp;nbsp &lt;/th>
         </xsl:text>
         <xsl:apply-templates select = "ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_ALIAS" /> 
      </tr >
      
      <tr> 
         <td class = "em">
          ^0804^
         </td> 
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_LTRSYSINDEX"/> 
      </tr>
      <tr> 
         <td class = "em">
          ^0803^
          </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "X_LG_CHNNELPOSITION"/> 
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_HOMERPTFREQINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_HOMERPTFREQINDEX"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_SCANLISTINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_SCANLISTINDEX"/>  
      </tr>
      <tr>
         <td class = "em">
            <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_AUTOSCANEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_AUTOSCANEN"/>         
      </tr>
      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PLK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'PFK') or
                      contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS') ">
         <tr> 
            <td class = "em">
              <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_PHSYSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_PHSYSINDEX"/>  
         </tr>
      </xsl:if>
      <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">
         <tr> 
            <td class = "em">
              <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_DATAREVERTPERSINDEX/@DISPLAY_NAME" />
            </td>
            <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAREVERTPERSINDEX"/>  
         </tr>
      </xsl:if>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_OPTBRDFEATEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_OPTBRDFEATEN"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_OPTBRDCONFIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_OPTBRDCONFIGINDEX"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_CALLLIGHT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_CALLLIGHT"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_DATAONLY/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAONLY"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_INTERCONNECTEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_INTERCONNECTEN"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TALKPERTONEEN/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TALKPERTONEEN"/>   
      </tr>
      <!-- TridentData-Alice -->
      <xsl:variable name = "cpver">
         <xsl:value-of select = "/ELP_ELM_CODEPLUG/RRW/TI_BLOCK/ENTRY_DATA/TI_LATCPVER" />
      </xsl:variable>     	
      <xsl:if test= "$cpver >= '06.00' "> 
         <xsl:if test = "/ELP_ELM_CODEPLUG/RRO/MDF_BLOCK/ENTRY_DATA/MDF_DATAOPERTRIDENT = '1'"> 
            <xsl:if test = "contains(/ELP_ELM_CODEPLUG/RRW/RC_BLOCK/ENTRY_DATA/X_MODEL, 'MPLUS')">                                                                           	
               <tr> 
                  <td class = "em">
                     <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_DATAOPERTRIDENTEN/@DISPLAY_NAME" />
                  </td>
                  <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_DATAOPERTRIDENTEN"/>   
               </tr>
            </xsl:if> 
         </xsl:if>
      </xsl:if>
      <!-- TridentData-Alice -->
      
      <!-- Rx Parameters -->
      <tr>
         <td class = "em1">
            ^0805^
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_RXLOWID/@DISPLAY_NAME" />
         </td>  
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_RXID"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_RXSIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_RXSIGINDEX"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_UNMUTETYPE/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_UNMUTETYPE"/>   
      </tr>
      
      <!-- Tx Parameters -->
      <tr>
         <td class = "em1">
            ^0806^
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TXID/@DISPLAY_NAME" />
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXID"/>   
         </td>
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TXINHIBITLOWID/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXINHIBITID"/>  
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TXSIGINDEX/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXSIGINDEX"/>  
      </tr>
      <tr> 
         <td class  = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TXPWRLEVSEL/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TXPWRLEVSEL"/>   
      </tr>
      <tr> 
         <td class = "em">
          <xsl:value-of select="/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA/LG_TOT/@DISPLAY_NAME" />
         </td>
         <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/ENTRY_DATA[position() &gt;= $startIndex and position() &lt;= $endIndex]" mode = "LG_TOT"/>   
      </tr>
               
      <xsl:text disable-output-escaping = "yes">
          &lt;/table>
      </xsl:text>
   </xsl:template >   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_ALIAS">
      <th>
         <xsl:apply-templates select = "ALIAS" />
      </th>
   </xsl:template>
 
   
   <xsl:template match="ENTRY_DATA" mode = "LG_AUTOSCANEN">
      <td>
         <xsl:value-of select = 'LG_AUTOSCANEN' />
      </td>
   </xsl:template>   
   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_OPTBRDFEATEN">
      <td>
         <xsl:value-of select = 'LG_OPTBRDFEATEN' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_CALLLIGHT">
      <td>
         <xsl:value-of select = 'LG_CALLLIGHT' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAONLY">
      <td>
         <xsl:value-of select = 'LG_DATAONLY' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_INTERCONNECTEN">
      <td>
         <xsl:value-of select = 'LG_INTERCONNECTEN' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TALKPERTONEEN">
      <td>
         <xsl:value-of select = 'LG_TALKPERTONEEN' />
      </td>
   </xsl:template>  
   <!-- TridentData-Alice --> 
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAOPERTRIDENTEN">
      <td>
         <xsl:value-of select = 'X_LG_DATAOPERTRIDENTEN' />
      </td>
   </xsl:template>  
   <!-- TridentData-Alice -->  
   <xsl:template match="ENTRY_DATA" mode = "LG_UNMUTETYPE">
      <td>
         <xsl:value-of select = 'LG_UNMUTETYPE' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXID">
      <td>
         <xsl:value-of select = 'LG_TXID' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXPWRLEVSEL">
      <td>
         <xsl:value-of select = 'LG_TXPWRLEVSEL' />
      </td>
   </xsl:template>   
   <xsl:template match="ENTRY_DATA" mode = "LG_TOT">
      <td>
         <xsl:value-of select = 'LG_TOT' />
      </td>
   </xsl:template>  
   
   <xsl:template match="ENTRY_DATA" mode = "LG_LTRSYSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_LTRSYSINDEX" />
      </xsl:variable>
      <td>
          <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LS_BLOCK/LIST_DATA[position() = ($index +1)]/ENTRY_INFO/ALIAS" />
      </td>
   </xsl:template>   
   
   <xsl:template match="ENTRY_DATA" mode = "X_LG_CHNNELPOSITION">
      <td>
        <xsl:call-template name = "X_LG_CHNNELPOSITION">
          <xsl:with-param name = 'alias' select = 'ALIAS'/>
          <xsl:with-param name = 'site_index' select = 'LG_LTRSYSINDEX'/>
        </xsl:call-template>
      </td>
   </xsl:template>   
   
   <xsl:template name="X_LG_CHNNELPOSITION">
       <xsl:param name = 'alias'/>
       <xsl:param name = 'site_index'/>      
       <xsl:for-each select = '/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA'>
           <xsl:if test = "ALIAS=$alias and LG_LTRSYSINDEX=$site_index">
               <xsl:variable name = 'index' select = 'position()-1' />
               <xsl:variable name = 'type'>LS Trunking</xsl:variable>
               <xsl:apply-templates select = '/ELP_ELM_CODEPLUG/RRW/PA_BLOCK/LIST_DATA/ENTRY_DATA[PA_PERSTYPE = $type and PA_PERSINDEX = $index]' mode = 'channel_position'/>
           </xsl:if>
       </xsl:for-each>
   </xsl:template>   
            
   <xsl:template match = "ENTRY_DATA" mode = 'channel_position'>
             <xsl:value-of select = 'count(preceding-sibling::*)'/>
   </xsl:template>     
   
   <xsl:template match="ENTRY_DATA" mode = "LG_HOMERPTFREQINDEX">
      <xsl:variable name = "siteindex">
          <xsl:value-of select = "LG_LTRSYSINDEX" />
      </xsl:variable>
      <xsl:variable name = "repeaterindex">
          <xsl:value-of select = "LG_HOMERPTFREQINDEX" />
      </xsl:variable>
      <td>
          <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LS_BLOCK/LIST_DATA[position() = ($siteindex +1)]/ENTRY_DATA[X_LRF_REPEATERNUMBER = ($repeaterindex +1)]/ALIAS" />      
      </td>
   </xsl:template>   
   
   <!-- TridentData-Alice -->
   <xsl:template match="ENTRY_DATA" mode = "LG_SCANLISTINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_SCANLISTINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/SLI_BLOCK/LIST_DATA[position() = ($index +1)]/ENTRY_INFO/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template> 
   <!-- TridentData-Alice -->  
   
   <!-- TridentData-Alice -->
   <xsl:template match="ENTRY_DATA" mode = "LG_RXSIGINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_RXSIGINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255' or LG_RXSIGTYPE = 'None'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK /ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template>
   <!-- TridentData-Alice -->  
   
   <!-- TridentData-Alice --> 
   <xsl:template match="ENTRY_DATA" mode = "LG_TXSIGINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_TXSIGINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "LG_DATAOPERTRIDENTEN = '1'">
               ^0316^
            </xsl:when>
            <xsl:when test = "$index = '255' or LG_TXSIGTYPE = 'None'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/MDC_BLOCK /ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template> 
   <!-- TridentData-Alice --> 
      
   <xsl:template match="ENTRY_DATA" mode = "LG_PHSYSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_PHSYSINDEX" />
      </xsl:variable>
      <td>
         <xsl:choose>
            <xsl:when test = "$index = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "$index != '255'"> 
               <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/PS_BLOCK/ENTRY_DATA[position() = ($index +1)]/ALIAS" />
            </xsl:when>
         </xsl:choose>
      </td>
   </xsl:template>   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_DATAREVERTPERSINDEX">
      <xsl:variable name = "index">
          <xsl:value-of select = "LG_DATAREVERTPERSINDEX" />
      </xsl:variable>
      <xsl:variable name = "con_type">Conventional</xsl:variable>
      <xsl:variable name = "lty_type">LS Trunking</xsl:variable>
      <xsl:choose>
          <xsl:when test = "$con_type = LG_DATAREVERTPERSTYPE">
              <td>CNV <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/CP_BLOCK/ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
          <xsl:when test = "$lty_type = LG_DATAREVERTPERSTYPE">
              <td>LTR <xsl:apply-templates select = "/ELP_ELM_CODEPLUG/RRW/LG_BLOCK/X_LG_ALIAS_LIST/X_ENTRY_DATA[position() = ($index+1)]/ALIAS"/></td>
          </xsl:when>
      </xsl:choose>
   </xsl:template>   
   
   <xsl:template match="ENTRY_DATA" mode = "LG_OPTBRDCONFIGINDEX">
      <td>
          <xsl:value-of select = "LG_OPTBRDCONFIGINDEX" />
      </td>
   </xsl:template>   
      
   <xsl:template match="ENTRY_DATA" mode = "LG_RXID">
      <td>
         <xsl:choose>
            <xsl:when test = "LG_RXLOWID = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "LG_RXHIGHID = '255'">
               ^0327^
            </xsl:when>
            <xsl:otherwise> 
                <xsl:value-of select = "LG_RXLOWID" />-<xsl:value-of select = "LG_RXHIGHID" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template> 
   
   <xsl:template match="ENTRY_DATA" mode = "LG_TXINHIBITID">
      <td>
         <xsl:choose>
            <xsl:when test = "LG_TXINHIBITLOWID = '255'">
               ^0327^
            </xsl:when>
            <xsl:when test = "LG_TXINHIBITHIGHID = '255'">
               ^0327^
            </xsl:when>
            <xsl:otherwise> 
                <xsl:value-of select = "LG_TXINHIBITLOWID" />-<xsl:value-of select = "LG_TXINHIBITHIGHID" />
            </xsl:otherwise>
         </xsl:choose>
      </td>
   </xsl:template>    
   
   <xsl:template match = 'X_CHANNAL_ALIAS'>
       <tr>
           <td class = "em">
               <xsl:value-of select = 'position()'/>
           </td>
           <td>
               <xsl:variable name = "oldAlias">
                   <xsl:value-of select="." />
               </xsl:variable>
               <xsl:call-template name = "aliastransform">
                   <xsl:with-param name = "aliasname1">
                       <xsl:value-of select = "$oldAlias" />
                   </xsl:with-param>
               </xsl:call-template>
           </td>
       </tr>
   </xsl:template>
   
<!-- FOR MOR & ATIS -->	
   <xsl:template match = 'RC_KANIIPPANMODE'>
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>
   <xsl:template match = 'TI_FIRMVER'>
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>
   <xsl:template match = 'TI_LATTIME'>
      <tr>
         <td class = "em">
            ^0412^
         </td>
         <td>
              <xsl:call-template name = "DATE">
              	<xsl:with-param name = "format">
                      ^0449^
                  </xsl:with-param>
             </xsl:call-template>             
            <xsl:variable name = "orighour">
               <xsl:value-of select = "substring-before(text(), ':')" />
            </xsl:variable>
            <xsl:variable name = "min">
               <xsl:value-of select = "substring-after(text(), ':')" />
            </xsl:variable>
            <xsl:choose>
               <xsl:when test = "$orighour = '00'">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     AM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:when test = "$orighour = '12'">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     PM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:when test = "$orighour > 12">
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "$orighour - 12" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     PM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour" />:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:when>
               <xsl:otherwise>
                  <xsl:variable name = "newhour">
                     <xsl:value-of select = "$orighour" />
                  </xsl:variable>
                  <xsl:variable name = "lateness">
                     AM
                  </xsl:variable>
                  <xsl:value-of select = "$newhour"/>:<xsl:value-of select = "$min" /> <xsl:value-of select = "$lateness" />
               </xsl:otherwise>
            </xsl:choose>
         </td>
      </tr>
   </xsl:template>
   <xsl:template match = 'RI_TANAPANUM'>
      <tr>
         <td class = "em">
            ^0907^
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>
   <xsl:template match = 'RC_ATISNO'>
      <tr>
         <td class = "em">
            <xsl:value-of select = "@DISPLAY_NAME"/>
         </td>
         <td>
            <xsl:value-of select="." /> 
         </td> 
      </tr>
   </xsl:template>   
   <xsl:template name = "DATE">
      <xsl:param name = 'format' />
      <xsl:variable name = "date" >
         <xsl:value-of select = "../TI_LATDATE" />
      </xsl:variable>
      <xsl:choose>
         <xsl:when test = "contains($format, 'YMD')" >
              <xsl:value-of select ="substring($date,7,4)" />/<xsl:value-of select ="substring($date,1,2)" />/<xsl:value-of select ="substring($date,4,2)" />,
         </xsl:when>
         <xsl:when test = "contains($format, 'DMY')" >
              <xsl:value-of select ="substring($date,4,2)" />/<xsl:value-of select ="substring($date,1,2)" />/<xsl:value-of select ="substring($date,7,4)" />,            
         </xsl:when>
         <xsl:otherwise>
            <xsl:value-of select = "translate($date, '-', '/')" />,
         </xsl:otherwise>
      </xsl:choose>
   </xsl:template>
   <xsl:template match="ENTRY_DATA" mode = "CP_DATATRANSOB">
	<td>
	       <xsl:value-of select="CP_DATATRANSOB" />
 	</td>
   </xsl:template>

</xsl:stylesheet>
